
#pragma once
#include "System.h"

// Q[
GAMESTATE GameState;

HMODULE hCSDLL;
SIMULATION_FUNC Simulation = nullptr;
CREATESHOT_FUNC CreateShot = nullptr;
CREATEHITSHOT_FUNC CreateHitShot = nullptr;
GETSCORE_FUNC GetScore = nullptr;

bool LoadFunction()
{
	hCSDLL = LoadLibrary("CurlingSimulator.dll");

	if (hCSDLL != nullptr){
		Simulation = (SIMULATION_FUNC)GetProcAddress(hCSDLL, "Simulation");
		CreateShot = (CREATESHOT_FUNC)GetProcAddress(hCSDLL, "CreateShot");
		CreateHitShot = (CREATEHITSHOT_FUNC)GetProcAddress(hCSDLL, "CreateHitShot");
		GetScore = (GETSCORE_FUNC)GetProcAddress(hCSDLL, "GetScore");
	}
	else{
		MessageBox(nullptr, "CurlingSimulator.dll ̓ǂݍ݂Ɏs܂", "G[", MB_OK);
		return false;
	}

	return true;
}

// bZ[W̑M
void Send(char *Message)
{
	DWORD NumberOfBytesWritten;
	WriteFile(GetStdHandle(STD_OUTPUT_HANDLE), Message, strlen(Message), &NumberOfBytesWritten, NULL);
}

// bZ[W̎M
void Recv(char *Message, size_t Size)
{
	DWORD NumberOfBytesRead;
	ReadFile(GetStdHandle(STD_INPUT_HANDLE), Message, Size, &NumberOfBytesRead, NULL);
}

// bZ[WMpXbh
DWORD WINAPI ReceiveCUIThread(LPVOID pParam)
{
	DWORD	bRet = TRUE;
	char	Message[1024];

	while (1){
		memset(Message, 0x00, sizeof(Message));
		Recv(Message, sizeof(Message));
		DoCommand(Message);
	}

	return bRet;
}

void main()
{
	char	Message[1024];
	DWORD	dwThreadId;
	DWORD	NumberOfBytesWritten;

	// ֐̓ǂݍ
	if (LoadFunction() != TRUE){
		return;
	}

	// Xbh̍쐬
	CreateThread(NULL, 0, (LPTHREAD_START_ROUTINE)ReceiveCUIThread, NULL, 0, &dwThreadId);

	// R}hM
	while (1){
		memset(Message, 0x00, sizeof(Message));
		Recv(Message, sizeof(Message));
		DoCommand(Message);
	}

	return;
}