import socket
import torch
import numpy as np
import copy
import json
import time
y_center=38.405
x_center=0
rot_r=0
device = torch.device('cuda') if torch.cuda.is_available() else torch.device('cpu')
class client:
    def __init__(self):
        self.inshot_table=np.load('shot_table.npy')
        self.outshot_table=np.load('outshot_table.npy')
        print("input sim port")
        sim_port=int(input())
        self.s=socket.socket(socket.AF_INET,socket.SOCK_STREAM)
        self.s.connect((socket.gethostname(),10000+sim_port))
        self.x_min=14
        self.y_min=41
        self.stone_rad=0.145
        self.y_center=38.405
        self.x_center=0
        self.wtable=[[0.919,0.771,0.609,0.340,0.162,0.034,0.015],
            [0.946,0.794,0.557,0.279,0.122,0.021,0.014],
            [0.962,0.881,0.677,0.260,0.042,0.011,0.011],
            [1.000,1.000,1.000,0.220,0.000,0.000,0.000]]
    
    def calc_score(self,sheet,num_stone):
        score=0
        No1=sheet[0][5]
        for i in range(16):
            if sheet[i][2]>1.829+self.stone_rad or sheet[i][5]==0:
                break
            if No1==sheet[i][5]:
                score+=1
            else:
                break
        score*=No1
        return score
    
    def calc_score2(self,sheet,end,player):
        score=0
        if end%2==1:
            for i in range(15):
                if player==1 and sheet[i][5]==-1:
                    sheet[i][5]=1
                    break
                if player==-1 and sheet[i][5]==1:
                    sheet[i][5]=-1
                    break
        No1=sheet[0][5]
        for i in range(15):
            if sheet[i][2]>1.829+self.stone_rad or sheet[i][5]==0:
                break
            if No1==sheet[i][5]:
                score+=1
            else:
                break
        score*=No1
        return score

    def create_sheet_data(self,sheet,shot_result,player,full=0):
        sheet_after_shot=np.zeros((15,7))
        for i in range(14):
            sheet_after_shot[i,0]=shot_result["stone"+str(i+1)][0]
            sheet_after_shot[i,1]=shot_result["stone"+str(i+1)][1]
            sheet_after_shot[i,2]=np.sqrt((shot_result["stone"+str(i+1)][0]-x_center)**2+(shot_result["stone"+str(i+1)][1]-y_center)**2)
            if sheet[i,5]==0:
                sheet_after_shot[i,2]=150
            sheet_after_shot[i,5]=sheet[i,5]
        sheet_after_shot[14,0]=shot_result["stone16"][0]
        sheet_after_shot[14,1]=shot_result["stone16"][1]
        sheet_after_shot[14,2]=np.sqrt((shot_result["stone16"][0]-x_center)**2+(shot_result["stone16"][1]-y_center)**2)
        sheet_after_shot[14,5]=player
        if full==1:
            for i in range(15):
                if sheet_after_shot[i,0]<-2.375 or sheet_after_shot[i,0]>2.375 or sheet_after_shot[i,1]>40.234 or sheet_after_shot[i,1]<32.004:
                    for j in range(7):
                        sheet_after_shot[i,j]=0
                    sheet_after_shot[i,2]=150
                else:
                    sheet_after_shot[i,3]=1
            sheet_after_shot=sheet_after_shot[np.argsort(sheet_after_shot[:,2])]
            for i in range(15):
                if sheet_after_shot[i,2]<1.829 and sheet_after_shot[i,5]!=0:
                        sheet_after_shot[i,4]=1
                elif sheet_after_shot[i,2]>=100:
                        sheet_after_shot[i,2]=0
            flag=False
            player=sheet_after_shot[0,5]
            for i in range(1,15):
                if sheet_after_shot[i,5]==0:
                    break
                if player!=sheet_after_shot[i,5]:
                    flag=True
                if flag:
                    sheet_after_shot[i,6]=1
        else:
            sheet_after_shot=sheet_after_shot[np.argsort(sheet_after_shot[:,2])]
        return sheet_after_shot

    
    def calc_winrate(self,rest_end,score_dist,score,player):
        winrate=0
        score_dist_aftershot=int(np.clip(score_dist+1+score,0,6))
        if rest_end==0:
            if score_dist_aftershot>3:
                winrate=1 
            elif score_dist_aftershot==3:
                if score>0:
                    winrate=0.22
                else:
                    winrate=0.78
            else:
                winrate=0
        else:
            if player==1:
                my_wtable=np.array(self.wtable)
                my_wtable=1-my_wtable[:,::-1]
            else:
                my_wtable=np.array(self.wtable)
            if score>0:
                my_wtable=1-my_wtable[:,::-1]
                winrate=my_wtable[3-rest_end,6-score_dist_aftershot]
            else:
                winrate=my_wtable[3-rest_end,6-score_dist_aftershot]
        return winrate
    
    def calc_score_rulebase_new(self,sheet_after_shot,player,end):
        alpha=1.83+self.stone_rad
        beta=1.22
        gamma=1.83+self.stone_rad
        a=0.915
        b=1.83
        w1=1
        w2=2
        if player==-1:
            mu=0.1
        else:
            mu=0.2
        if player==-1:
            e=self.calc_score2(sheet_after_shot.copy(),end,player)
            #print(e)
            if e==-1 and sheet_after_shot[0][5]==1:
                e=0.1
        else:
            e=self.calc_score(sheet_after_shot,15)
        #e=self.calc_score(sheet_after_shot,15)*2
        e*=2
        #print(self.calc_score(sheet_after_shot,15),self.calc_score2(sheet_after_shot,end,player))
        num_enemy_stone=0
        for i in range(14):
            if sheet_after_shot[i][5]==0:
                break
            ns=0
            for j in range(i):
                if sheet_after_shot[j][5]==-1:
                    ns+=1
                else:
                    break
            ks=1/(1+ns)
            hx=0
            if abs(sheet_after_shot[i][0]-self.x_center)<alpha and player==1:
                hx=1-abs(sheet_after_shot[i][0]-self.x_center)/alpha
            elif abs(sheet_after_shot[i][0]-self.x_center)<alpha and player==-1:
                hx=abs(sheet_after_shot[i][0]-self.x_center)/alpha
            hy=0.01
            if self.y_center-beta < sheet_after_shot[i][1] and sheet_after_shot[i][1]<self.y_center:
                hy=(sheet_after_shot[i][1]-self.y_center+beta)*(sheet_after_shot[i][1]-self.y_center+beta)/(beta*beta)
            elif self.y_center<sheet_after_shot[i][1] and sheet_after_shot[i][1]<self.y_center+gamma:
                hy=1-(sheet_after_shot[i][1]-self.y_center)*(sheet_after_shot[i][1]-self.y_center)/(gamma*gamma)
            js=w1*ks+w2*hx*hy
            #print(hy)
            ds=1
            Tmax=0.1
            if sheet_after_shot[i][5]==-1 and sheet_after_shot[i][2]<1.829:
                num_enemy_stone+=1
            
            for j in range(15):
                if sheet_after_shot[j][5]==0:
                    break
                
                if i!=j:
                    if sheet_after_shot[i][5]==sheet_after_shot[j][5]:
                        d=np.linalg.norm(sheet_after_shot[i,:2]-sheet_after_shot[j,:2])
                        D2=a+b*abs(sheet_after_shot[i][1]-sheet_after_shot[j][1])/d
                        dist=1
                        if d<D2:
                            dist=0.5+0.5*d*d/(D2*D2)
                        if dist<ds:
                            ds=dist
                        if sheet_after_shot[j][1]-sheet_after_shot[i][1]>4*self.stone_rad and sheet_after_shot[j][1]-sheet_after_shot[i][1]<1.829:
                            T=0
                            if abs(sheet_after_shot[i][0]-sheet_after_shot[j][0])<1*self.stone_rad:
                                T=1
                            elif abs(sheet_after_shot[i][0]-sheet_after_shot[j][0])<alpha:
                                T=1/(abs(sheet_after_shot[i][0]-sheet_after_shot[j][0])+1)
                            if Tmax<T:
                                Tmax=T
                
            N=js/ds
            e+=mu*N*sheet_after_shot[i][5]*Tmax
        #print(e)
        #if player==1:
        e-=num_enemy_stone*1
        return e

    def calc_score_rulebase(self,sheet_after_shot,player,end):
        alpha=1.83+self.stone_rad
        beta=1.22
        gamma=1.83+self.stone_rad
        a=0.915
        b=1.83
        w1=1
        w2=1
        if player==-1:
            mu=0.1
        else:
            mu=0.2
        if player==-1:
            e=self.calc_score2(sheet_after_shot.copy(),end,player)
            #print(e)
            if e==-1 and sheet_after_shot[0][5]==1:
                e=0.1
        else:
            e=self.calc_score(sheet_after_shot,15)
        e*=1
        num_enemy_stone=0
        for i in range(14):
            if sheet_after_shot[i][5]==0:
                break
            ns=0
            for j in range(i):
                if sheet_after_shot[j][5]==-1:
                    ns+=1
                else:
                    break
            ks=1/(1+ns)
            hx=0.0
            if player==-1:
                if abs(sheet_after_shot[i][0]-self.x_center)<alpha:
                    hx=1-abs(sheet_after_shot[i][0]-self.x_center)/alpha

            else:
                if sheet_after_shot[i][2]<alpha:
                    hx=abs(sheet_after_shot[i][0]-self.x_center)/alpha
                

            hy=0.0
            y=-(self.y_center-sheet_after_shot[i][1])+4.88
            if 4.88-beta < y and y<4.88:
                hy=(y-4.88+beta)*(y-4.88+beta)/(beta*beta)
            elif 4.88<y and y<4.88+gamma:
                hy=1-(y-4.88)*(y-4.88)/(gamma*gamma)
            
            js=w1*ks+w2*hx*hy
            #print(hy)
            ds=1
            Tmax=0.01
            if sheet_after_shot[i][5]==-1 and sheet_after_shot[i][2]<1.829:
                num_enemy_stone+=1
            
            for j in range(15):
                if sheet_after_shot[j][5]==0:
                    break
                
                if i!=j:
                    if sheet_after_shot[i][5]==sheet_after_shot[j][5]:
                        d=np.linalg.norm(sheet_after_shot[i,:2]-sheet_after_shot[j,:2])
                        D2=a+b*abs(sheet_after_shot[i][1]-sheet_after_shot[j][1])/d
                        dist=1
                        if d<D2:
                            dist=0.5+0.5*d*d/(D2*D2)
                        if dist<ds:
                            ds=dist
                        if sheet_after_shot[j][1]-sheet_after_shot[i][1]>8*self.stone_rad and sheet_after_shot[j][1]-sheet_after_shot[i][1]<1.829:
                            T=0
                            if abs(sheet_after_shot[i][0]-sheet_after_shot[j][0])<1*self.stone_rad:
                                T=1
                            elif abs(sheet_after_shot[i][0]-sheet_after_shot[j][0])<alpha:
                                T=1/(abs(sheet_after_shot[i][0]-sheet_after_shot[j][0])+1)
                            if Tmax<T:
                                Tmax=T
                
            N=js/ds
            e+=mu*N*sheet_after_shot[i][5]*Tmax
        #print(e)
        if player==1:
            e-=num_enemy_stone*0.5
        return e
    def rule_base(self,player,end,stones,field):
        
        opt=np.zeros(3)
        field_win_rate=np.zeros((29,61,2))
        outshot_winrate=np.zeros((79,2))
        emax=-10
        for rot in range(2):
            for dx in range(-self.x_min,self.x_min+1):
                #for dy in range(-16,17,2):
                for dy in range(-36,17,2):
                    target_x=dx*self.stone_rad
                    target_y=dy*self.stone_rad+self.y_center
                    shot_result=self.shot(stones,target_x,target_y,rot)
                    sheet_after_shot=self.create_sheet_data(field,shot_result,1)
                    
                    if end < 6:
                        stone_cant_move=0
                        for i in range(15):
                            if field[i][5]==0:
                                break
                            if field[i][5]==-1 and field[i][1]<y_center and field[i][2]>1.829+self.stone_rad:
                                stone_cant_move+=1
                        for i in range(15):
                            if sheet_after_shot[i][5]==0:
                                break
                            if sheet_after_shot[i][5]==-1 and sheet_after_shot[i][1]<y_center and sheet_after_shot[i][2]>1.829+self.stone_rad:
                                stone_cant_move-=1
                        if stone_cant_move>0:
                            field_win_rate[dx+self.x_min,dy+self.y_min,rot]=-1
                        else:
                            field_win_rate[dx+self.x_min,dy+self.y_min,rot]=self.calc_score_rulebase(sheet_after_shot,player,end)
                    else:
                        field_win_rate[dx+self.x_min,dy+self.y_min,rot]=self.calc_score_rulebase(sheet_after_shot,player,end)
                    if dy==-36:
                        field_win_rate[dx+self.x_min,dy+self.y_min-2:dy+self.y_min+2,rot]=field_win_rate[dx+self.x_min,dy+self.y_min,rot]
                    else:
                        field_win_rate[dx+self.x_min,dy+self.y_min+1,rot]=field_win_rate[dx+self.x_min,dy+self.y_min,rot]
                    #print(dx,dy,e)
            for dx in range(79):
                if rot==rot_r:
                    target_x=x_center+self.stone_rad*dx*0.25-0.69875-0.25*self.stone_rad*4
                else:
                    target_x=x_center+self.stone_rad*dx*0.25-1.875-0.25*self.stone_rad*4
                target_y=-(38.405-6.039+4.88)
                shot_result=self.shot(stones,target_x,target_y,rot)
                sheet_after_shot=self.create_sheet_data(field,shot_result,1)
                if end < 6:
                    stone_cant_move=0
                    for i in range(15):
                        if field[i][5]==0:
                            break
                        if field[i][5]==-1 and field[i][1]<y_center and field[i][2]>1.829+self.stone_rad:
                            stone_cant_move+=1
                    for i in range(15):
                        if sheet_after_shot[i][5]==0:
                            break
                        if sheet_after_shot[i][5]==-1 and sheet_after_shot[i][1]<y_center and sheet_after_shot[i][2]>1.829+self.stone_rad:
                            stone_cant_move-=1
                    if stone_cant_move>0:
                        outshot_winrate[dx,rot]=-1
                    else:
                        outshot_winrate[dx,rot]=self.calc_score_rulebase(sheet_after_shot,player,end)
                else:
                    outshot_winrate[dx,rot]=self.calc_score_rulebase(sheet_after_shot,player,end)

        best_win_rate=-10
        field_win_rate2=np.zeros((25,51,2))
        for rot in range(2):
                for sx in range(25):
                    #for ty in range(18,51):
                    for ty in range(0,51):
                        win_rate=0
                        j=-2
                        k=-2
                        for i in range(43):
                            win_rate+=field_win_rate[sx+j+2,ty+k+5,rot]*self.inshot_table[sx,ty+2,rot,i]
                            if i==4 or i==15 or i==26:
                                j+=1
                                k=-5
                            elif i==37:
                                j+=1
                                k=-2
                            else:
                                k+=1
                        field_win_rate2[sx,ty,rot]=win_rate
                        if best_win_rate<win_rate:
                            best_win_rate=win_rate
                            opt[0]=sx
                            opt[1]=ty
                            opt[2]=rot
                            #print(best_win_rate)
                for sx in range(71):
                    win_rate=0
                    for i in range(0,9):
                        win_rate+=outshot_winrate[sx+i,rot]*self.outshot_table[sx,rot,i]
                    if best_win_rate<win_rate:
                        best_win_rate=win_rate
                        opt[0]=sx
                        opt[1]=-1
        print(best_win_rate,opt)
        return opt
    

    

    def shot(self,stones,target_x,target_y,rot):
        if rot==0:
            stones["shot"]=[target_x,target_y,-1]
        else:
            stones["shot"]=[target_x,target_y,1]
        json_shot=(json.dumps(stones)+'\n').encode('utf-8')
        t1=time.time()
        self.s.send(bytes(json_shot))
        response = self.s.recv(1024)
        shot_result=json.loads(response.decode('utf-8'))
        return shot_result


    def Expectimax(self,field,shot_num,end,score_dist):
        if shot_num==1:
            opt=np.zeros(3)
            opt[0]=14
            opt[1]=11
            opt[2]=0
            return 0,opt
        his=np.zeros(11)
        #print('serch')
        if shot_num%2==1:
            shot_player=-1
        else:
            shot_player=1
        flag=0
        enemy_stone_num=0
        enemy_stone_num2=0
        my_stone_num=0
        score=0
        opt=np.zeros(3)
        stones={}
        stones["result"]=[0,0]
        
        for i in range(15):
            stones["stone"+str(i+1)]=[field[i][0],field[i][1],field[i][5]]
            if field[i][5]==-1:
                enemy_stone_num+=1
                if field[i][2]<1.829+self.stone_rad:
                    enemy_stone_num2+=1
                flag=1
            elif field[i][5]==1:
                my_stone_num+=1
            else:# field[i][5]==0:
                break
        num_stone=i
        if shot_num<16:#%2==1 and shot_num!=15:
            opt=self.rule_base(shot_player,shot_num,stones,field)
            return 0,opt
        else:
            field_win_rate=np.zeros((29,61,2))
            #sheet_score=np.zeros((29,61,2))
            outshot_winrate=np.zeros((79,2))
            sheet_score_out=np.zeros((79,2))
            sheet_score=np.zeros((29,61,2))
            num_stone=i
            for rot in range(2):
                for dx in range(-self.x_min,self.x_min+1):
                    for dy in range(-16,17,2):
                        target_x=dx*self.stone_rad
                        target_y=dy*self.stone_rad+self.y_center
                        shot_result=self.shot(stones,target_x,target_y,rot)
                        sheet_after_shot=self.create_sheet_data(field,shot_result,1)
                        score=self.calc_score(sheet_after_shot,num_stone)#*shot_player
                        sheet_score[dx+self.x_min,dy+self.y_min,rot]=score

                        field_win_rate[dx+self.x_min,dy+self.y_min,rot]=self.calc_winrate(end,score_dist,score,shot_player)
                        #sheet_score[dx+self.x_min,dy+self.y_min,rot]=score
                        if dy==-16:
                            field_win_rate[dx+self.x_min,dy+self.y_min-2:dy+self.y_min+2,rot]=field_win_rate[dx+self.x_min,dy+self.y_min,rot]
                        else:
                            field_win_rate[dx+self.x_min,dy+self.y_min+1,rot]=field_win_rate[dx+self.x_min,dy+self.y_min,rot]
                            sheet_score[dx+self.x_min,dy+self.y_min+1,rot]=sheet_score[dx+self.x_min,dy+self.y_min,rot]
                
                for dx in range(79):
                    if rot==rot_r:
                        target_x=x_center+self.stone_rad*dx*0.25-0.69875-0.25*self.stone_rad*4
                    else:
                        target_x=x_center+self.stone_rad*dx*0.25-1.875-0.25*self.stone_rad*4
                    target_y=-(38.405-6.039+4.88)
                    shot_result=self.shot(stones,target_x,target_y,rot)
                    sheet_after_shot=self.create_sheet_data(field,shot_result,1)
                    score=self.calc_score(sheet_after_shot,num_stone)
                    sheet_score_out[dx,rot]=score
                    #print(score)
                    outshot_winrate[dx,rot]=self.calc_winrate(end,score_dist,score,shot_player)
            best_win_rate=0
            best_score=-10

            for rot in range(2):
                for sx in range(25):
                    for ty in range(18,51):
                        win_rate=0
                        score=sheet_score[sx+2,ty+5,rot]
                        j=-2
                        k=-2
                        for i in range(43):
                            win_rate+=field_win_rate[sx+j+2,ty+k+5,rot]*self.inshot_table[sx,ty+2,rot,i]
                            if i==4 or i==15 or i==26:
                                j+=1
                                k=-5
                            elif i==37:
                                j+=1
                                k=-2
                            else:
                                k+=1
                            
                        if best_win_rate<win_rate or (best_win_rate==win_rate and score>best_score):
                            best_win_rate=win_rate
                            best_score=score
                            opt[0]=sx
                            opt[1]=ty
                            opt[2]=rot
                            #print(best_win_rate)
                for sx in range(71):
                    win_rate=0
                    score=sheet_score_out[sx+4,rot]
                    for i in range(0,9):
                        win_rate+=outshot_winrate[sx+i,rot]*self.outshot_table[sx,rot,i]
                    if best_win_rate<win_rate or (best_win_rate==win_rate and score>best_score):
                        best_win_rate=win_rate
                        best_score=score
                        opt[0]=sx
                        opt[1]=-1
                        opt[2]=rot
            #print(his)
            return best_win_rate,opt


shottable=np.load('shot_velocty_inshot_new.npy')
outshottable=np.load('shot_velocty_outshot_new.npy')
client1=client()
#client1=client()
print("INPUT SERVER port")
server_port=int(input())
s=socket.socket(socket.AF_INET,socket.SOCK_STREAM)
s.settimeout(600)
host_name=socket.gethostbyname("digitalcurling.ddns.net")
print(host_name)
s.connect((host_name,20000+server_port))
response = s.recv(1024)
print(response)

dc={
        "cmd": "dc_ok",
        "name": "Jiritsukun-Jr"
    }
json_dc=(json.dumps(dc)+'\n').encode('utf-8')
#print(json_dc)
time.sleep(0.1)
s.send(json_dc)

response = s.recv(4096)
print(response)
response=json.loads(response.decode('utf-8'))
team=response["team"]
print(team)
if team=='team1':
    enemy_team='team0'
else:
    enemy_team='team1'
ready={
    "cmd": "ready_ok",
    "player_order": [
        3,  
        1,  
        2, 
        0 
    ]
}
json_ready=(json.dumps(ready)+'\n').encode('utf-8')
time.sleep(0.5)
s.send(json_ready)
response = s.recv(4096)
print('ready')
print(response)
num_end=10
#response = s.recv(4096)
#print(response)
score_dist=2
num=0
while(True):
    #time.sleep(1)
    message = ""
    message_buffer = ""
    while True:

        if message_buffer != "":
            message_recv = message_buffer
            message_buffer = ""
        else:
            message_recv: str = s.recv(4096).decode("utf-8")  # type: ignore
        message += message_recv
        if "\n" in message_recv:
            # split message by "\n"
            message_split = message.split("\n")
            # set first message to message
            message = message_split[0]
            # set second and later message to message_buffer
            message_buffer = "\n".join(message_split[1:])
            break

    st = json.dumps(message)
    json_data = json.loads(st)
    response = json.loads(json_data)
    num+=1
    if True:
        #print(response["next_team"])
        if response["cmd"]=="game_over":
            print("gameover")
            break
        if response["next_team"]==team:
            end=int(response["state"]["end"])
            shotnum=int(response["state"]["shot"])
            print('shot_number',shotnum)
            stones=response["state"]["stones"][team]
            stones2=response["state"]["stones"][enemy_team]
            my_score=response["state"]["scores"][team]
            enemy_score=response["state"]["scores"][enemy_team]
            if shotnum==0 or shotnum==1:

                score_dist=2
                if end>num_end:
                    my_extrascore=response["state"]["extra_end_scores"][team]
                    enemy_extrascore=response["state"]["extra_end_scores"][enemy_team]
                    for i in range(num_end):
                        score_dist+=my_score[i]-enemy_score[i]
                    if score_dist<0:
                        score_dist=0
                    elif score_dist>4:
                        score_dist=4
                    for i in range(end-num_end):
                        score_dist+=my_extrascore[i]-enemy_extrascore[i]
                    print('score',score_dist-2)
                    if score_dist<0:
                        score_dist=0
                    elif score_dist>4:
                        score_dist=4
                else:
                    for i in range(end):
                        score_dist+=my_score[i]-enemy_score[i]
                    print('score',score_dist-2)
                    if score_dist<0:
                        score_dist=0
                    elif score_dist>4:
                        score_dist=4
                print('end:',end)
                

            field=np.zeros((16,7))
            i=0
            for stone in stones:
                if stone != None:
                    field[i,0]=stone["position"]["x"]
                    field[i,1]=stone["position"]["y"]
                    field[i,2]=np.sqrt((field[i,0])**2+(field[i,1]-y_center)**2)
                    field[i,3]=1
                    field[i,5]=1
                else:
                    field[i,2]=150
                i+=1
            for stone in stones2:
                if stone != None:
                    field[i,0]=stone["position"]["x"]
                    field[i,1]=stone["position"]["y"]
                    field[i,2]=np.sqrt((field[i,0])**2+(field[i,1]-y_center)**2)
                    field[i,3]=1
                    field[i,5]=-1
                else:
                    field[i,2]=150
                i+=1
            field=field[np.argsort(field[:,2])]
            for i in range(16):
                if field[i,2]<1.829 and field[i,5]!=0:
                        field[i,4]=1
                elif field[i,2]==150:
                        field[i,2]=0
            flag=False
            player=field[0,5]
            for i in range(1,16):
                if field[i,5]==0:
                    break
                if player!=field[i,5]:
                    flag=True
                if flag:
                    field[i,6]=1
            #end=0
            t1=time.time()
            #print(field)
            if num_end-end<0:
                end=0
            elif num_end-end>3:
                end=3
            else:
                end=num_end-end
            #print(field)
            value,opt=client1.Expectimax(field=field[0:15],shot_num=shotnum+1,end=end,score_dist=score_dist)
            #print(time.time()-t1)
            
            move={
            "cmd": "move",
            "move": {
                "type": "shot",
                "velocity": { "x": 0.1, "y": 2.0 },
                "rotation": "ccw"
            }
            }
            x=int(opt[0])
            y=int(opt[1])
            print(x,y,value)
            if y<0:
                move["move"]["velocity"]["x"]=outshottable[x,int(opt[2]),0]
                move["move"]["velocity"]["y"]=outshottable[x,int(opt[2]),1]
            else:
                move["move"]["velocity"]["x"]=shottable[x,y,int(opt[2]),0]
                move["move"]["velocity"]["y"]=shottable[x,y,int(opt[2]),1]
            
            if int(opt[2])==0:
                move["move"]["rotation"]="cw"
            else:
                move["move"]["rotation"]="ccw"
            json_move=(json.dumps(move)+'\n').encode('utf-8')
            time.sleep(0.1)
            s.send(json_move)


