import numpy as np
from build.Release.simulator import StoneSimulator
#from mcts.FCV1Simulation.src.build.Release.simulator import StoneSimulator
import json
import sys
import os
import matplotlib.pyplot as plt

import time

# 現在のスクリプトのパスを取得
current_dir = os.path.dirname(os.path.abspath(__file__))

# プロジェクトルートまでのパスを計算（例：srcの1階層上）
project_root = os.path.join(current_dir, '../../..')  # ← パス構造に応じて調整

# パスを追加
sys.path.insert(0, os.path.normpath(project_root))
from mcts.utils import add_noise_to_vector

stone_simulator = StoneSimulator()

kTeeLineYOnSimulation = 17.3735 #ティーの位置
kHackYOnSimulation = 21.0315 #ハック？（定数）
kHouseRadius = 1.829 #ハウスの半径
kStoneRadius = 0.145 #ストーンの半径
#STDDV_SPEED = 0.0076
#STDDV_ANGLE = 0.0018
STDDV_SPEED = 0.00
STDDV_ANGLE = 0.00

iteration = 0
results_history = [] 
sum = 0

def calculate_score(result):
    coordinates = result.reshape(-1, 2)
    target_point = np.array([0, kHackYOnSimulation + kTeeLineYOnSimulation])
    MAX_DISTANCE = kHouseRadius + kStoneRadius 
    filtered_and_sorted_indices = sorted(
        [i for i in range(len(coordinates)) if np.linalg.norm(coordinates[i] - target_point) < MAX_DISTANCE],
        key=lambda i: np.linalg.norm(coordinates[i] - target_point)
    )
    score = 0
    if len(filtered_and_sorted_indices) > 0:
        if filtered_and_sorted_indices[0] < 8:
            for i in range(len(filtered_and_sorted_indices)):
                if filtered_and_sorted_indices[i] < 8:
                    score += 1
                else:
                    break
        else:
            for i in range(len(filtered_and_sorted_indices)):
                if filtered_and_sorted_indices[i] >= 8:
                    score -= 1
                else:
                    break
    return score

def convert_format(data):
    result = []
    for item in data:
        if item is None:
            result.append(0.0)
            result.append(0.0)
        else:
            # 角度と座標を抽出してフォーマット
            result.append(item["position"]["x"])
            result.append(item["position"]["y"])
    return result

def plot_coordinates(data):
    # データをNumPy配列に変換
    arr = np.array(data)
    
    # 座標ペアに分割
    coords = arr.reshape(-1, 2)
    
    # チーム分割（前半と後半）
    split_idx = len(coords) // 2
    team1 = coords[:split_idx]
    team2 = coords[split_idx:]
    
    # プロット設定
    plt.figure(figsize=(10, 6))
    
    # チーム1のプロット（青い丸）
    mask = (team1[:,0] != 0) | (team1[:,1] != 0)
    plt.scatter(team1[mask,0], team1[mask,1], 
                marker='o', s=100, color='blue', label='Team 1')
    
    # チーム2のプロット（赤い×印）
    mask = (team2[:,0] != 0) | (team2[:,1] != 0)
    plt.scatter(team2[mask,0], team2[mask,1], 
                marker='x', s=100, color='red', label='Team 2')
    
    # グラフ装飾
    plt.title('Curling Stone Positions', fontsize=14)
    plt.xlabel('X Position', fontsize=12)
    plt.ylabel('Y Position', fontsize=12)
    plt.grid(True, linestyle='--', alpha=0.7)
    plt.legend()
    #plt.axis('equal')  # アスペクト比を等しく
    
    # 座標範囲の調整
    plt.xlim(-10, 10)
    plt.ylim(32, 45)
    
    plt.show()

def simulate():
    global results_history, sum, iteration
    '''input_data = {
        "team0":[None,{"angle":-36.894222259521484,"position":{"x":0.12412136793136597,"y":36.265846252441406}},{"angle":-35.53358459472656,"position":{"x":0.9272226095199585,"y":35.729515075683594}},{"angle":-41.405723571777344,"position":{"x":-1.5276628732681274,"y":36.65793991088867}},{"angle":29.735795974731445,"position":{"x":0.43378013372421265,"y":36.12826156616211}},{"angle":32.16817092895508,"position":{"x":0.37570101022720337,"y":35.07768249511719}},{"angle":-36.43535232543945,"position":{"x":-0.7723680138587952,"y":37.3245964050293}},{"angle":-34.9987907409668,"position":{"x":-0.11310571432113647,"y":38.58953094482422}}],
       "team1":[None,{"angle":-35.806602478027344,"position":{"x":0.051481664180755615,"y":35.96034622192383}},{"angle":-35.032493591308594,"position":{"x":-1.9461923837661743,"y":38.104705810546875}},{"angle":-37.88424301147461,"position":{"x":0.26323753595352173,"y":40.25062942504883}},{"angle":34.51168441772461,"position":{"x":-1.0137667655944824,"y":36.924137115478516}},{"angle":34.30986785888672,"position":{"x":0.4306563436985016,"y":37.72211456298828}},{"angle":-35.137081146240234,"position":{"x":0.15681692957878113,"y":38.13975524902344}},None]
    }
    input_data = {
        "team0":[None,{"angle":-38.91719436645508,"position":{"x":0.8655399084091187,"y":36.32801055908203}},{"angle":-39.537841796875,"position":{"x":1.2197277545928955,"y":38.40801239013672}},{"angle":-38.37863540649414,"position":{"x":-1.5896881818771362,"y":37.3939208984375}},{"angle":35.47492599487305,"position":{"x":-1.1486396789550781,"y":36.28468704223633}},{"angle":35.46392822265625,"position":{"x":-0.44927799701690674,"y":39.01609802246094}},{"angle":-30.06694793701172,"position":{"x":-0.08129154145717621,"y":35.57257080078125}},{"angle":-34.70222091674805,"position":{"x":-0.830525279045105,"y":36.8807258605957}}],
        "team1":[None,{"angle":-36.410221099853516,"position":{"x":0.40869438648223877,"y":36.8471565246582}},{"angle":-39.766483306884766,"position":{"x":0.4212947189807892,"y":38.94636917114258}},{"angle":-40.913177490234375,"position":{"x":-1.1222935914993286,"y":36.910072326660156}},{"angle":37.573951721191406,"position":{"x":0.7648725509643555,"y":35.463172912597656}},{"angle":35.82392883300781,"position":{"x":0.27400249242782593,"y":36.339942932128906}},{"angle":-33.612998962402344,"position":{"x":-0.012748407199978828,"y":37.328636169433594}},None]
        }
    input_data = {
        "team0":[None,{"angle":-36.42082977294922,"position":{"x":0.6205349564552307,"y":36.65561294555664}},{"angle":-25.945825576782227,"position":{"x":-1.6863600015640259,"y":38.2840461730957}},{"angle":-38.04191589355469,"position":{"x":0.16205687820911407,"y":39.55957794189453}},{"angle":34.05989074707031,"position":{"x":0.4213407337665558,"y":35.736083984375}},{"angle":33.68446350097656,"position":{"x":-0.8848453760147095,"y":37.73066711425781}},{"angle":-29.324783325195313,"position":{"x":0.051314808428287506,"y":35.64664840698242}},{"angle":-28.936594009399414,"position":{"x":0.4164971709251404,"y":37.05480194091797}}],
        "team1":[{"angle":38.8897819519043,"position":{"x":-0.012011377140879631,"y":39.91780090332031}},{"angle":-34.547752380371094,"position":{"x":0.2749136984348297,"y":36.4229850769043}},{"angle":-23.399751663208008,"position":{"x":-1.679404616355896,"y":36.92993927001953}},{"angle":-36.409332275390625,"position":{"x":-0.2071218639612198,"y":38.66421890258789}},{"angle":38.40553665161133,"position":{"x":0.7098738551139832,"y":35.56113052368164}},{"angle":38.69908142089844,"position":{"x":-0.49961158633232117,"y":38.56132507324219}},{"angle":-35.10239028930664,"position":{"x":0.04828441143035889,"y":37.9747314453125}},None]
        }
    input_data = {
        "team0":[None,{"angle":-36.27308654785156,"position":{"x":0.5214414596557617,"y":37.91790008544922}},{"angle":-37.73807144165039,"position":{"x":0.9597011804580688,"y":36.0333251953125}},{"angle":-25.149656295776367,"position":{"x":-1.2334100008010864,"y":37.76100540161133}},{"angle":35.19422149658203,"position":{"x":-1.065402865409851,"y":36.45182800292969}},{"angle":35.23599624633789,"position":{"x":0.5300281643867493,"y":35.194618225097656}},{"angle":-31.760007858276367,"position":{"x":-0.9151891469955444,"y":35.799007415771484}},{"angle":-30.61014175415039,"position":{"x":-0.7641465663909912,"y":34.68679428100586}}],
        "team1":[{"angle":37.266334533691406,"position":{"x":-0.029434295371174812,"y":39.84489440917969}},{"angle":-38.64225387573242,"position":{"x":0.8257179856300354,"y":37.001888275146484}},{"angle":-36.11879348754883,"position":{"x":0.5050868988037109,"y":38.56220245361328}},{"angle":-25.971782684326172,"position":{"x":-1.168865442276001,"y":35.644527435302734}},{"angle":28.1391544342041,"position":{"x":1.2955104112625122,"y":37.821495056152344}},{"angle":27.8353271484375,"position":{"x":-0.1387302130460739,"y":38.662593841552734}},{"angle":-29.157094955444336,"position":{"x":0.7194095849990845,"y":37.52095031738281}},None]
        }'''
    '''
        input_data = {
        "team0":[None,{"angle":-33.453853607177734,"position":{"x":0.22592893242835999,"y":37.868080139160156}},{"angle":-37.33383560180664,"position":{"x":0.03855988010764122,"y":36.998043060302734}},{"angle":-37.45460891723633,"position":{"x":0.0335160456597805,"y":39.25193786621094}},{"angle":28.970897674560547,"position":{"x":0.3274271786212921,"y":36.87311935424805}},{"angle":28.982444763183594,"position":{"x":1.1306973695755005,"y":36.50363540649414}},{"angle":-33.49443435668945,"position":{"x":-0.8945737481117249,"y":34.56584167480469}},{"angle":-32.39949035644531,"position":{"x":-0.2737974226474762,"y":36.79705047607422}}],
        "team1":[{"angle":39.04544448852539,"position":{"x":-0.04419165849685669,"y":40.21770477294922}},{"angle":-35.329872131347656,"position":{"x":1.1991031169891357,"y":38.09697723388672}},{"angle":-37.46894454956055,"position":{"x":-0.7416633367538452,"y":35.862396240234375}},{"angle":-35.17768096923828,"position":{"x":-0.2111700177192688,"y":39.675811767578125}},{"angle":29.9364013671875,"position":{"x":0.6771133542060852,"y":37.025264739990234}},{"angle":32.97430419921875,"position":{"x":0.44590523838996887,"y":34.45674514770508}},{"angle":-32.403411865234375,"position":{"x":-0.5391191840171814,"y":38.373931884765625}},None]
        }
    '''
    input_data = {
        "team0":[None,{"angle":-37.73793411254883,"position":{"x":0.6398116946220398,"y":36.22296142578125}},{"angle":-36.19669723510742,"position":{"x":-0.06948262453079224,"y":38.32609558105469}},{"angle":-27.1846923828125,"position":{"x":-0.8021680116653442,"y":38.74407958984375}},{"angle":34.51713943481445,"position":{"x":0.6226169466972351,"y":35.08734130859375}},{"angle":30.185543060302734,"position":{"x":-0.1401744931936264,"y":36.42431640625}},{"angle":-28.111614227294922,"position":{"x":-0.7040110230445862,"y":36.264469146728516}},{"angle":-38.96469497680664,"position":{"x":-1.6038532257080078,"y":36.17902755737305}}],
        "team1":[None,{"angle":-34.95297622680664,"position":{"x":0.8557391166687012,"y":38.59547424316406}},{"angle":-34.458457946777344,"position":{"x":-1.1342978477478027,"y":37.88976287841797}},{"angle":-28.997835159301758,"position":{"x":-0.9093003869056702,"y":37.59474182128906}},{"angle":28.74506950378418,"position":{"x":0.7132195234298706,"y":37.67123031616211}},{"angle":41.07051467895508,"position":{"x":0.2998826205730438,"y":37.636531829833984}},{"angle":-32.080718994140625,"position":{"x":0.3282923698425293,"y":34.86098098754883}},None]
    }
    cmbined_data = input_data["team0"] + input_data["team1"]

    with open("data.json", "r") as read_file:
        data = json.load(read_file)

    position: list = data["position"]
    np_position = np.array(position)

    #np_position = np.array(convert_format(cmbined_data))

    shot = data["shot"]
    for i in range(0):
        ix, iy = add_noise_to_vector(0.0241935, 2.95484, STDDV_SPEED, STDDV_ANGLE)
        if ix > 0.0326904:
            #print("ix: ", ix)
            if iy > 2.9637:
                print("hakkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkennnnnnnnnnnnnnnnnnn")
                print("iy: ", iy)
                print(i)
    x, y = add_noise_to_vector(data["x_velocities"][0], data["y_velocities"][0], STDDV_SPEED, STDDV_ANGLE)
    #x_velocities: list = data["x_velocities"]
    #if iteration % 2 == 0:
        #x = 0.0326904
        #y = 2.9637
        #print("irekaetaoooooooooooooooooooooooo")
    x_velocities: list = [x]
    #y_velocities: list = data["y_velocities"]
    y_velocities: list = [y]
    angular_velocities: list = data["angular_velocities"]
    np_x_velocities = np.array(x_velocities)
    np_y_velocities = np.array(y_velocities)
    np_angular_velocities = np.array(angular_velocities)
    #print(np_position)
    print("x_velocities: ", np_x_velocities)
    #print("y_velocities: ", np_y_velocities)
    #print(np_position, shot, np_x_velocities, np_y_velocities, np_angular_velocities)
    start_time = time.time()
    for _ in range(100):
        result, flag = stone_simulator.simulator(np_position, shot, np_x_velocities, np_y_velocities, np_angular_velocities)
    end_time = time.time()
    elapsed_time = end_time - start_time
    print(f"処理時間: {elapsed_time}秒")
    iaa = 0
    '''
    for prev_result in results_history:
        iaa += 1
        if np.array_equal(result, prev_result):
            print("same result")
            print("iaa: ", iaa)
            break
            '''
    # print(result)
    #print("bbb")
    #print("flag: ", flag)
    #print("aaa")
    #result[0][0] = 1.210408091545105
    #result[0][1] = 36.581085205078125
    print(result)
    #print(iteration)
    results_history.append(result)
    #print("score: ", calculate_score(result))
    sum += calculate_score(result)
    #if calculate_score(result) != 1:
        #print("aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa")
    plot_coordinates(np_position)
    #plot_coordinates(result[0])
    plot_coordinates([-0.18203676, 40.23213959  ,0.0          ,0.0          ,1.0126214,  37.05007935,
   0.0          ,0.0          ,0.31202275, 37.02836609,  0.0   ,       0.0,
  -1.51000488, 37.39151764, -0.89633679, 36.09506989,  0.14161339, 39.6774826,
   1.5553633,  36.96615982, -0.73996538, 38.94371033, -0.3791689,  37.43959808,
   0.44835308, 35.38370514,  0.68334109, 34.66038895,  0.85802335, 36.39487839,
  -1.14475894, 37.4360466 ])
    print("before: ", np_position, "x: ", np_x_velocities, ", y: ", np_y_velocities, ", result: ", result)


for iteration in range(1):
    simulate()
print("sum: ", sum)
print("average: ", sum / 1)