import numpy as np
from mcts.config import N_SCORE


def idx_to_score(idx):
    assert(0 <= idx and idx <= N_SCORE-1)
    return idx - 8

def score_to_idx(score):
    assert(-8 <= score and score <= 8)
    return int(score + 8)

def dist_v_to_exp_v(dist_v):
    score_array = np.zeros(N_SCORE)
    for i in range(N_SCORE):
        score_array[i] = idx_to_score(i)
        #score_array[i] = i
    exp_v = np.sum(score_array * dist_v)
    return exp_v

import numpy as np

def add_noise_to_vector(x, y, stddev_speed, stddev_angle):
    """
    直交座標 (x, y) のベクトルを極座標に変換し、大きさと角度に異なる正規分布の乱数を加え、
    再び直交座標に変換して新しいベクトルを返す。

    :param x: ベクトルの x 成分
    :param y: ベクトルの y 成分
    :param mag_stddev: 大きさに加える正規分布の標準偏差
    :param angle_stddev: 角度に加える正規分布の標準偏差 (ラジアン)
    :return: (新しい x, 新しい y)
    """
    # 直交座標 -> 極座標
    magnitude = np.sqrt(x**2 + y**2)  # 大きさ
    angle = np.arctan2(y, x)          # 角度（ラジアン）

    # 正規分布に従う乱数を加える
    noisy_magnitude = magnitude + np.random.normal(0.0, stddev_speed)
    noisy_angle = angle + np.random.normal(0.0, stddev_angle)

    # 極座標 -> 直交座標
    new_x = noisy_magnitude * np.cos(noisy_angle)
    new_y = noisy_magnitude * np.sin(noisy_angle)

    return new_x, new_y


"""
def idx_to_score(idx): #勝率テーブル適応（仮）後攻に探索することしか考慮してないし、勝率テーブルも+1と0を入れ替えただけ
    assert(0 <= idx and idx <= N_SCORE-1)
    if idx == 8: #0点の場合
        return idx - 7
    elif idx == 9: #1点の場合
        return idx - 9
    return idx - 8
"""
