"""ニューラルネットワークの入力特徴生成処理
"""
import numpy as np
import math

from board.constant import BOARD_SIZE, X_MIN, X_MAX, Y_MIN, Y_MAX, Y_TEE, R_HOUSE, VX_MIN, VX_MAX, VY_MIN, VY_MAX

def discretization(x: float, y: float, xmin: float, xmax: float, ymin: float, ymax: float):
    count = 0
    while not (xmin <= x <= xmax and ymin <= y <= ymax):
        if count > 5:
            x = 0.0
            y = 2.4
            break
        if x < xmin:
            y = y * (xmin / x)
            x = xmin
        elif x > xmax:
            y = y * (xmax / x)
            x = xmax
        if y < ymin:
            x = x * (ymin / y)
            y = ymin
        elif y > ymax:
            x = x * (ymax / y)
            y = ymax
        count += 1
    x_interval = (xmax - xmin) / (BOARD_SIZE - 1)
    y_interval = (ymax - ymin) / (BOARD_SIZE - 1)
    x_index = int((x - xmin) / x_interval)
    y_index = int((y - ymin) / y_interval)
    index = x_index + (BOARD_SIZE * y_index)
    return index

def is_house(x: float, y: float):
    distance = math.sqrt(x ** 2 + (y - Y_TEE) ** 2)
    return distance <= R_HOUSE
 
def sort_order_by_distance(order):
    sorted_order = sorted(order, key=lambda x: np.sqrt(x[1] ** 2 + (x[2] - Y_TEE) ** 2))
    return sorted_order



def generate_input_planes(stones: list, shot: int) -> np.ndarray: #jsonファイルの['log']['simulator_storage']['stones']と['log']['shot']を入力し、29の特徴平面を出力する。
    board_size = BOARD_SIZE
    num_planes = 29
    planes = np.zeros(shape=(num_planes, board_size ** 2))
    planes[0][:] = 1 #空点
    planes[3][:] = 1 #定数平面
    turn_number = (shot // 2) + 5
    planes[turn_number][:] = 1 #ターン番号
    me = 1
    if shot % 2 == 1: #自分が先攻か後攻か
        me = 2

    order = np.full(shape=(16, 3), fill_value=-1)
    for i in range(16):
        if stones[i]:
            x = stones[i]['position']['x']
            y = np.abs(stones[i]['position']['y'])
            index = discretization(x, y, X_MIN, X_MAX, Y_MIN, Y_MAX)
            planes[0][index] = 0 #空点の更新

            if i < 8:
                planes[me][index] = 1 #自分のストーンの更新
            else:
                planes[3 - me][index] = 1 #相手のストーンの更新

            if is_house(x, y):
                planes[4][index] = 1 #ハウス内にあるストーン

            order[i] = [index, x, y]
    
    sorted_order = sort_order_by_distance(order)
    j = 13
    for item in sorted_order: #ティーからの順番
        if item[0] == -1:
            break
        planes[j][item[0]] = 1
        j += 1
    
    return planes.reshape(num_planes, board_size, board_size).astype(np.float32)
            

def generate_target_data(selected_move: dict) ->np.ndarray:
    board_size = BOARD_SIZE
    policy_plane = np.zeros(shape=(2, board_size ** 2))
    vx = selected_move['velocity']['x']
    vy = selected_move['velocity']['y']
    vindex = discretization(vx, vy, VX_MIN, VX_MAX, VY_MIN, VY_MAX)
    if selected_move['rotation'] == "cw":
        policy_plane[0][vindex] = 1
    else:
        policy_plane[1][vindex] = 1
    #return policy_plane.reshape(2, board_size, board_size).astype(np.float32)
    return policy_plane.reshape((board_size ** 2) * 2).astype(np.float32)


def generate_value_data(dcl_data, end, shot) ->np.ndarray:
    team0 = dcl_data['log']['state']['scores']['team0']
    team1 = dcl_data['log']['state']['scores']['team1']
    senko = np.zeros(10)
    for i in range(9):
        if team0[i] == team1[i]:
            senko[i+1] = senko[i]
        elif team0[i] < team1[i]:
            senko[i+1] = 1
        else:
            senko[i+1] = 0
    
    diff = 8 + team0[end] - team1[end]
    if senko[end] != shot % 2 : #自分がteam1だった場合
        diff = 16 - diff

    value = np.zeros(17)
    value[diff] = 1
    return value.astype(np.float32)
    



            

            


    

