import subprocess
from copy import deepcopy
import json
import os
import numpy as np
import sys
import os
from dc3client.models import StoneRotation
from mcts.utils import add_noise_to_vector

from mcts.FCV1Simulation.src.build.Release.simulator import StoneSimulator

#current_dir = os.path.dirname(__file__)
#simulate_path = os.path.join(current_dir, "../Simulate_DigitalCurling3/build/Debug/simulate_digitalcurling3")
#json_path = os.path.join(current_dir, "../output.json")

kTeeLineYOnSimulation = 17.3735 #ティーの位置
kHackYOnSimulation = 21.0315 #ハック？（定数）
kHouseRadius = 1.829 #ハウスの半径
kStoneRadius = 0.145 #ストーンの半径

STDDV_SPEED = 0.0076
STDDV_ANGLE = 0.0018

class CurlingEnv:
    def __init__(self, num_shot=0, end=0, last_end=9, score=None, stones=None, team = 'team0'):
        new_stones = []
        if stones is not None:
            for item in stones:
                if item is None:
                    new_stones.append(None)
                else:
                    new_stones.append({
                        "angle": item[0],
                        "position": {
                            "x": item[1],
                            "y": item[2]
                        }

                    })
        else:
            new_stones = [None] * 16

        white_to_move = (num_shot % 2 != 0)

        self.game_state = {
            "num_shot": num_shot,
            "end": end,
            "last_end": last_end,
            "score": score if score is not None else [0] * 10,
            "WhiteToMove": white_to_move,
            "stones": new_stones,
            "team": team
        }



    def step(self, x, y, rotation, stone_simulator: StoneSimulator):
        #実際にショットをシミュレーション
        #if (x < 0 and rotation == StoneRotation.counterclockwise) or (x >= 0 and rotation == StoneRotation.clockwise):
        rand_x, rand_y = add_noise_to_vector(x, y, STDDV_SPEED, STDDV_ANGLE)
        #print("x: ", x, ", y: ", y, ", rand_x: ", rand_x, ", rand_y: ", rand_y)
        next_env = deepcopy(self)
        rotation_index = 1.0
        if rotation == StoneRotation.counterclockwise:
            rotation_index = -1.0
        shot = self.game_state["num_shot"]
        position: list = []
        for item in self.game_state["stones"]:
            if item is None:
                position.append(0.0)
                position.append(0.0)
            else:
                if(item["position"]["y"] < 21.0315):
                    print("mainasuaruyo: ", item["position"]["y"])
                position.append(item["position"]["x"])
                position.append(item["position"]["y"])
        if(not next_env.team_check()):
            position = position[16:32] + position[0:16]
        x_velocities: list = [rand_x]
        y_velocities: list = [rand_y]
        angular_velocities: list = [rotation_index]
        np_position = np.array(position)
        np_x_velocities = np.array(x_velocities)
        np_y_velocities = np.array(y_velocities)
        np_angular_velocities = np.array(angular_velocities)
        #print("before")
        result, _ = stone_simulator.simulator(np_position, shot, np_x_velocities, np_y_velocities, np_angular_velocities)
        #print("after")
        #print("before: ", np_position, "x: ", np_x_velocities, ", y: ", np_y_velocities,", rotation: ", rotation, ", result: ", result)
        if shot == 15: #shotの値がどのように扱われているか要確認
            #print(rand_x, rand_y, rotation_index)
            #if result[0][-1] != 0.0:
                #print(result)
            next_env.game_state["stones"] = [None] * 16
            score = calculate_score(result)
            if self.game_state["WhiteToMove"] :
                score *= -1
            next_env.game_state["score"][self.game_state["end"]] = score
            #if score != calculate_score(np_position):
                #print("before: ", np_position, "x: ", np_x_velocities, ", y: ", np_y_velocities,", rotation: ", rotation, ", result: ", result, ", score: ", score)
            #next_env.game_state["score"][self.game_state["end"]] = calculate_score(result)
            #この上の行を自分がteam0か1かで条件分岐しなきゃいけなそう。
            #if self.game_state["WhiteToMove"] :
                #next_env.game_state["score"][self.game_state["end"]] *= -1
            next_env.game_state["num_shot"] = 0
            next_env.game_state["end"] = self.game_state["end"] + 1
            if next_env.game_state["end"] >= 10 :
                next_env.game_state["end"] = 0 #とりあえず0にした。もうちょいきれいな方法ありそう。
            next_env.game_state["WhiteToMove"] = False
        else:
            newstones = []
            coordinates = result.reshape(-1, 2)
            for item in coordinates:
                if item[0] == 0.0 and item[1] ==0.0:
                    newstones.append(None)
                else:
                    newstones.append({
                        "angle": 0.0,#シミュレータには角度の概念がないため仮置き
                        "position": {
                            "x": item[0],
                            "y": item[1]
                        }
                    })
            if(not next_env.team_check()):
                newstones = newstones[8:16] + newstones[0:8]
            next_env.game_state["stones"] = newstones
            next_env.game_state["num_shot"] = self.game_state["num_shot"] + 1
            next_env.game_state["WhiteToMove"] = not next_env.game_state["WhiteToMove"]

        #とりあえずここまで作った
        return next_env

    def team_check(self):
        if((self.game_state["team"] == 'team0' and (not self.game_state["WhiteToMove"])) or (self.game_state["team"] == 'team1' and (self.game_state["WhiteToMove"]))):
            #rint(11111111)
            return True
        else:
            #rint(22222222)
            return False
            

#シミュレータの結果から得点を計算
def calculate_score(result):
    coordinates = result.reshape(-1, 2)
    target_point = np.array([0, kHackYOnSimulation + kTeeLineYOnSimulation])
    MAX_DISTANCE = kHouseRadius + kStoneRadius 
    filtered_and_sorted_indices = sorted(
        [i for i in range(len(coordinates)) if np.linalg.norm(coordinates[i] - target_point) < MAX_DISTANCE],
        key=lambda i: np.linalg.norm(coordinates[i] - target_point)
    )
    score = 0
    if len(filtered_and_sorted_indices) > 0:
        if filtered_and_sorted_indices[0] < 8:
            for i in range(len(filtered_and_sorted_indices)):
                if filtered_and_sorted_indices[i] < 8:
                    score += 1
                else:
                    break
        else:
            for i in range(len(filtered_and_sorted_indices)):
                if filtered_and_sorted_indices[i] >= 8:
                    score -= 1
                else:
                    break
    return score