import torch
import subprocess
import json
import numpy as np

from nn.network.dual_net import DualNet
from dc3client.models import StoneRotation, Position, Coordinate, Stones
from board.constant import BOARD_SIZE, VX_MIN, VX_MAX, VY_MIN, VY_MAX


def generate_move_from_policy(network: DualNet, input):
    input_data = torch.tensor(input.reshape(1, 29, BOARD_SIZE, BOARD_SIZE))
    policy, _ = network.forward_with_softmax2(input_data)
    policy = policy.reshape(BOARD_SIZE * BOARD_SIZE * 2)
    max_index = np.argmax(policy)
    #print("type: ", type(policy))
    selected_index = max_index
    """
     # policyをNumPy配列に変換
    policy_np = policy.detach().cpu().numpy()  # GPUテンソル対応も考慮

    # 降順で並べ替えたインデックスを取得
    sorted_indices = np.argsort(policy_np)[::-1]

    # 上位3つのインデックスを取得
    max_index = sorted_indices[0]
    second_max_index = sorted_indices[1]
    third_max_index = sorted_indices[2]

    # 結果を表示
    print(selected_index)
    print("最大値のインデックス:", max_index)
    print("2番目に大きい値のインデックス:", second_max_index)
    print("3番目に大きい値のインデックス:", third_max_index)
    """
    return index_to_shot(selected_index)

def index_to_shot(index):
    rotation = StoneRotation.clockwise
    if(index >= (BOARD_SIZE * BOARD_SIZE)):
        rotation = StoneRotation.counterclockwise
        index = index - (BOARD_SIZE * BOARD_SIZE)
    
    x_index = index % BOARD_SIZE
    y_index = index // BOARD_SIZE
    x_interval = (VX_MAX - VX_MIN) / (BOARD_SIZE - 1)
    y_interval = (VY_MAX - VY_MIN) / (BOARD_SIZE - 1)
    x = float(x_index * x_interval + VX_MIN)
    y = float(y_index * y_interval + VY_MIN)
    return x, y, rotation



'''def generate_move_from_policy(network: DualNet, input):
    input_data = torch.tensor(input.reshape(1, 29, BOARD_SIZE, BOARD_SIZE))
    policy, _ = network.forward_with_softmax2(input_data)
    policy = policy.reshape(BOARD_SIZE * BOARD_SIZE * 2)
    max_index = np.argmax(policy)

    candidates = []
    for index, prob in enumerate(policy):
        if prob >= (policy[max_index] * 0.1):
            candidates.append(index)
    selected_index = random.choices(candidates, weights=[policy[i] for i in candidates])[0]

    rotation = StoneRotation.clockwise
    if(selected_index >= (BOARD_SIZE * BOARD_SIZE)):
        rotation = StoneRotation.counterclockwise
        selected_index = selected_index - (BOARD_SIZE * BOARD_SIZE)
    
    x_index = selected_index % BOARD_SIZE
    y_index = selected_index // BOARD_SIZE
    x_interval = (VX_MAX - VX_MIN) / (BOARD_SIZE - 1)
    y_interval = (VY_MAX - VY_MIN) / (BOARD_SIZE - 1)
    x = float(x_index * x_interval + VX_MIN)
    y = float(y_index * y_interval + VY_MIN)
    return x, y, rotation'''


