import numpy as np

kTeeLineYOnSimulation = 17.3735 #ティーの位置
kHackYOnSimulation = 21.0315 #ハック？（定数）
kHouseRadius = 1.829 #ハウスの半径
kStoneRadius = 0.145 #ストーンの半径

def score_test(stones):
    result_stones =[]
    for stone in stones:
        if stone is None:
            result_stones.append([0.0, 0.0])
        else:
            result_stones.append(stone[1:])
    result_stones = np.array(result_stones)
    target_point = np.array([0, kHackYOnSimulation + kTeeLineYOnSimulation])
    MAX_DISTANCE = kHouseRadius + kStoneRadius 
    filtered_and_sorted_indices = sorted(
        [i for i in range(len(result_stones)) if np.linalg.norm(result_stones[i] - target_point) < MAX_DISTANCE],
        key=lambda i: np.linalg.norm(result_stones[i] - target_point)
    )
    score = 0
    if len(filtered_and_sorted_indices) > 0:
        if filtered_and_sorted_indices[0] < 8:
            for i in range(len(filtered_and_sorted_indices)):
                if filtered_and_sorted_indices[i] < 8:
                    score += 1
                else:
                    break
        else:
            for i in range(len(filtered_and_sorted_indices)):
                if filtered_and_sorted_indices[i] >= 8:
                    score -= 1
                else:
                    break
    print("このプログラムが思っている得点: ", score)
    print("一番近いストーンの座標: ", result_stones[filtered_and_sorted_indices[0]])
    return
